%% Do not* change anything in this file %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%*******  define Jacobian matrix for phis ******%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Time derivative by Backward Euler
% F(block1)=((dt)*A_cs-1)cs(t)+(dt)f_cs(cs(t))+cs(t-1)=0
% F(block2)=((dt)*A_ce-1)ce(t)+(dt)f_ce(cs(t))+ce(t-1)=0
% F(block3)=A_phie(ce)*[ce;phie]+f_phie
% F(block4)=A_phis*phis+f_phis+Biapp
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function J_phis =bat_phis_J(y_in)
global eta tem sv sigmaEffFACE dx n_n n_s n_t n_p nr FARADAY RU...
       alpha_a alpha_c concS_max_n...
       concS_max_p kcon_n kcon_p A_phis 
N_np=n_n+n_p;
T=tem(1);
conc=y_in((n_n+n_p)+n_t+1:n_n+n_p+n_t+n_t);
concS_surf=y_in((n_n+n_p)+n_t+n_t+nr*(n_n+n_p)+1:(n_n+n_p)+n_t+n_t+nr*(n_n+n_p)+n_t);
%% define BV equation
Jli_phis=zeros(N_np,1);
for k=1:n_n
    i0=kcon_n*(conc(k)^alpha_a)*((concS_max_n-concS_surf(k))^alpha_a)*(concS_surf(k)^alpha_c);
    exp1= exp((alpha_a * FARADAY/( RU * T ))* eta(k));
    exp2= exp(-(alpha_c * FARADAY/( RU * T))* eta(k));
    Jli_phis(k)=(sv(k)*i0*FARADAY/RU/T)*(alpha_a*exp1+alpha_c*exp2);
end
for k=n_n+n_s+1:n_n+n_p+n_s
    i0=kcon_p*(conc(k)^alpha_a)*((concS_max_p-concS_surf(k))^alpha_a)*(concS_surf(k)^alpha_c);
    exp1= exp((alpha_a * FARADAY/( RU * T ))* eta(k));
    exp2= exp(-(alpha_c * FARADAY/( RU * T))* eta(k));
    Jli_phis(k)=(sv(k)*i0*FARADAY/RU/T)*(alpha_a*exp1+alpha_c*exp2);
end 
%% define jacobian matrix for Phis
%************************* define A_phis matrix **%%%**********************%
for i=1;
    A_phis_n(i,i)=-2*sigmaEffFACE(i+1)/(dx(i)+dx(i+1));
    A_phis_n(i,i+1)=2*sigmaEffFACE(i+1)/(dx(i)+dx(i+1));
end
for i=2:n_n-1
    A_phis_n(i,i-1)=2*sigmaEffFACE(i)/(dx(i)+dx(i-1));
    A_phis_n(i,i)=-((2*sigmaEffFACE(i)/(dx(i)+dx(i-1)))+...
             (2*sigmaEffFACE(i+1)/(dx(i)+dx(i+1))));
    A_phis_n(i,i+1)=2*sigmaEffFACE(i+1)/(dx(i)+dx(i+1));
end
for i=n_n;
    A_phis_n(i,i-1)=2*sigmaEffFACE(i)/(dx(i)+dx(i-1));
    A_phis_n(i,i)=-2*sigmaEffFACE(i)/(dx(i)+dx(i-1));
end

for i=1;
    A_phis_p(i,i)=-2*sigmaEffFACE(i+n_n+n_s+1)/(dx(i+n_n+n_s)+dx(i+n_n+n_s+1));
    A_phis_p(i,i+1)=2*sigmaEffFACE(i+n_n+n_s+1)/(dx(i+n_n+n_s)+dx(i+n_n+n_s+1));
end
for i=2:n_p-1
    j=i+n_n+n_s;
    left=2*sigmaEffFACE(j)/(dx(j)+dx(j-1));
    right=2*sigmaEffFACE(j+1)/(dx(j)+dx(j+1));
    A_phis_p(i,i-1)=left;
    A_phis_p(i,i)=-(left+right);
    A_phis_p(i,i+1)=right;
end

for i=n_p;
    j=i+n_n+n_s;
    A_phis_p(i,i-1)=2*sigmaEffFACE(j)/(dx(j)+dx(j-1));
    A_phis_p(i,i)=-2*sigmaEffFACE(j)/(dx(j)+dx(j-1));
end
A_phis(1:n_n,1:n_n)=A_phis_n;
A_phis(n_n+1:N_np,n_n+1:N_np)=A_phis_p;

f_phis=-Jli_phis'.*dx;
J_phis=(A_phis)+diag([f_phis(1:n_n) f_phis(n_n+n_s+1:n_t)]);






